(function( $ ) {
    'use strict';
    var VisualCellsAnimation = {
        initCells: function () {
            elementorFrontend.hooks.addAction('frontend/element_ready/section', VisualCellsAnimation.initCellsWidget);
        },
        initCellsWidget: function ($scope) {
            var sectionId = $scope.data('id');
            var target = '.elementor-element-' + sectionId;
            var settings = {};
            if (window.isEditMode || window.elementorFrontend.isEditMode()) {
                var editorElements = null;
                var cellsAnimationArgs = {};

                if (!window.elementor.hasOwnProperty('elements')) {
                    return false;
                }

                editorElements = window.elementor.elements;

                if (!editorElements.models) {
                    return false;
                }

                $.each(editorElements.models, function (i, el) {
                    if (sectionId === el.id) {
                        cellsAnimationArgs = el.attributes.settings.attributes;
                    } else if (el.id === $scope.closest('.elementor-top-section').data('id')) {
                        $.each(el.attributes.elements.models, function (i, col) {
                            $.each(col.attributes.elements.models, function (i, subSec) {
                                cellsAnimationArgs = subSec.attributes.settings.attributes;
                            });
                        });
                    }
                    settings.switch = cellsAnimationArgs.marvy_enable_cells_animation;
                    settings.colorOne = cellsAnimationArgs.marvy_cells_animation_color;
                    settings.colorTwo = cellsAnimationArgs.marvy_cells_animation_color_two;
                    settings.size = cellsAnimationArgs.marvy_cells_animation_size;
                    settings.speed = cellsAnimationArgs.marvy_cells_animation_speed;
                });

            } else {
                settings.switch = $scope.data("marvy_enable_cells_animation");
                settings.colorOne = $scope.data("marvy_cells_animation_color");
                settings.colorTwo = $scope.data("marvy_cells_animation_color_two");
                settings.size = $scope.data("marvy_cells_animation_size");
                settings.speed = $scope.data("marvy_cells_animation_speed");
            }

            if (settings.switch) {
                cellsAnimation(target, settings, sectionId);
            }
        }
    };

    function cellsAnimation(target,settings,sectionId) {
        var checkElement = document.getElementsByClassName("marvy-cells-section-" + sectionId);
        if (checkElement.length >= 0) {

            var cells_div = document.createElement('div');
            cells_div.classList.add("marvy-cells-section-" + sectionId);

            document.querySelector(target).appendChild(cells_div);
            document.querySelector(target).classList.add("marvy-custom-cells-animation-section-" + sectionId);

            // Set Z-index for section container
            var cellsZindex = document.querySelector('.marvy-custom-cells-animation-section-'+sectionId+' .elementor-container');
            cellsZindex.style.zIndex = '99';

            var cellAnimation = VANTA.CELLS({
                el: ".marvy-cells-section-" + sectionId,
                mouseControls: true,
                touchControls: true,
                gyroControls: false,
                minHeight: 100.00,
                scale: 1.00,
                scaleMobile: 1.00,
                color1: settings.colorOne,
                color2: settings.colorTwo,
                size: settings.size,
                speed: settings.speed
            });
            render(cellAnimation,sectionId);
        }
        return true;
    }

    function render(animation,sectionId) {
        document.querySelector(".elementor-element-"+sectionId).addEventListener('DOMAttrModified', function(e){
            animation.resize();
        }, false);
    }

    $( window ).on('elementor/frontend/init', VisualCellsAnimation.initCells);
})( jQuery );